%------------------------------------------------------------------------------
% File     : SEU707^2 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Set Theory
% Problem  : Conditionals
% Version  : Especial > Reduced > Especial.
% English  : (! A:i.! phi:o.! x:i.in x A -> (! y:i.in y A -> phi ->
%            if A phi x y = x))

% Refs     : [Bro08] Brown (2008), Email to G. Sutcliffe
% Source   : [Bro08]
% Names    : ZFC209l [Bro08]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.11 v7.2.0, 0.12 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.29 v6.1.0, 0.14 v6.0.0, 0.29 v5.5.0, 0.33 v5.4.0, 0.40 v5.3.0, 0.60 v5.2.0, 0.40 v4.1.0, 0.33 v4.0.1, 0.67 v3.7.0
% Syntax   : Number of formulae    :   13 (   0 unit;   8 type;   4 defn)
%            Number of atoms       :   81 (  12 equality;  46 variable)
%            Maximal formula depth :   16 (   7 average)
%            Number of connectives :   55 (   3   ~;   3   |;   6   &;  30   @)
%                                         (   0 <=>;  13  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   11 (  11   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   8   :;   0   =)
%            Number of variables   :   21 (   0 sgn;  14   !;   0   ?;   7   ^)
%                                         (  21   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : http://mathgate.info/detsetitem.php?id=263
%          : 
%------------------------------------------------------------------------------
thf(in_type,type,(
    in: $i > $i > $o )).

thf(setunion_type,type,(
    setunion: $i > $i )).

thf(dsetconstr_type,type,(
    dsetconstr: $i > ( $i > $o ) > $i )).

thf(singleton_type,type,(
    singleton: $i > $o )).

thf(iftrueProp1_type,type,(
    iftrueProp1: $o )).

thf(iftrueProp1,definition,
    ( iftrueProp1
    = ( ! [A: $i,Xphi: $o,Xx: $i] :
          ( ( in @ Xx @ A )
         => ! [Xy: $i] :
              ( ( in @ Xy @ A )
             => ( Xphi
               => ( in @ Xx
                  @ ( dsetconstr @ A
                    @ ^ [Xz: $i] :
                        ( ( Xphi
                          & ( Xz = Xx ) )
                        | ( ~ ( Xphi )
                          & ( Xz = Xy ) ) ) ) ) ) ) ) ) )).

thf(ifSingleton_type,type,(
    ifSingleton: $o )).

thf(ifSingleton,definition,
    ( ifSingleton
    = ( ! [A: $i,Xphi: $o,Xx: $i] :
          ( ( in @ Xx @ A )
         => ! [Xy: $i] :
              ( ( in @ Xy @ A )
             => ( singleton
                @ ( dsetconstr @ A
                  @ ^ [Xz: $i] :
                      ( ( Xphi
                        & ( Xz = Xx ) )
                      | ( ~ ( Xphi )
                        & ( Xz = Xy ) ) ) ) ) ) ) ) )).

thf(if_type,type,(
    if: $i > $o > $i > $i > $i )).

thf(if,definition,
    ( if
    = ( ^ [A: $i,Xphi: $o,Xx: $i,Xy: $i] :
          ( setunion
          @ ( dsetconstr @ A
            @ ^ [Xz: $i] :
                ( ( Xphi
                  & ( Xz = Xx ) )
                | ( ~ ( Xphi )
                  & ( Xz = Xy ) ) ) ) ) ) )).

thf(theeq_type,type,(
    theeq: $o )).

thf(theeq,definition,
    ( theeq
    = ( ! [X: $i] :
          ( ( singleton @ X )
         => ! [Xx: $i] :
              ( ( in @ Xx @ X )
             => ( ( setunion @ X )
                = Xx ) ) ) ) )).

thf(iftrue,conjecture,
    ( iftrueProp1
   => ( ifSingleton
     => ( theeq
       => ! [A: $i,Xphi: $o,Xx: $i] :
            ( ( in @ Xx @ A )
           => ! [Xy: $i] :
                ( ( in @ Xy @ A )
               => ( Xphi
                 => ( ( if @ A @ Xphi @ Xx @ Xy )
                    = Xx ) ) ) ) ) ) )).

%------------------------------------------------------------------------------
